//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Distribution of inheritances (2019)
// Objective: 	Cleaning the data to allow a histogram of the distribution of
//				inheritances in 2019 to be created in excel.
//
// Created: 	06/07/2021
// Modified: 	15/11/2021
//==============================================================================

**************************************
*** Loading and cleaning the data ***
**************************************

clear	// clearing the dataset

cd "XXXX"	// set the content directory here

use HILDA_restricted_combined_rescaled	// importing the unconfidentialised HILDA data for waves 1-19 that includes the new weights for residents of non-private dwellings

xtset xwaveid wave	// declaring the dataset to be a panel

merge m:1 year using CPI_FY_2018, nogen	// merging in a financial-year CPI series with 2018 as the base year

keep if oifinha > 0				// keeping observations with a positive inheritance recorded
keep if wave >= 2				// keeping observations from wave 18
keep oifinha benchmarked_new_hhwtrp cpi	// keeping only the inheritance variable, responding-person population weights and the cpi variable

*********************
*** Data analysis ***
*********************

gen oifinha_2018 = oifinha * 100 / cpi	// calculating 2018 values

egen inheritance_band = cut(oifinha_2018), at(0(10000)500000)	// generating inheritance bands of $10 000

collapse(sum) benchmarked_new_hhwtrp, by(inheritance_band)	// counting the number of population inheritances received within each band

save Inheritances_2002_2019.dta, replace	// saving the dataset